#include <allegro.h>
#include <stdlib.h>

#include "actor.h"
#include "man.h"
#include "sectors.h"

int sector_get(float x)
{
	return (((int)x >> SECTOR_SHIFT) & (SECTORS - 1));
}

ACTOR *sector_mans[SECTORS][MAX_MANS_PER_SECTOR];
int sector_mans_num[SECTORS] = {0};

void sectors_init(void)
{
	int i;
	for (i = 0; i < SECTORS; i++) {
		sector_mans_num[i] = 0;
	}
}

int sector_place_man(ACTOR *actor)
{
	int sector = sector_get(actor->x);
	
	if (sector_mans_num[sector] == MAX_MANS_PER_SECTOR) return 0;

	sector_mans[sector][sector_mans_num[sector]] = actor;
	
	sector_mans_num[sector]++;
	
	return 1;
	
}

void sector_wake_up_mans(int sector)
{
	sector &= SECTORS - 1;
	for (; sector_mans_num[sector]; sector_mans_num[sector]--) {
		int i = sector_mans_num[sector] - 1;
		if(mans_num == ACTIVE_MANS) break;
		man[mans_num] = sector_mans[sector][i];
		mans_num++;
	}
}
